<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwbehaviors wwsplits wwmode wwfiles wwdoc wwproject wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterDocumentSplitsType" />
 <xsl:param name="ParameterType" />


 <xsl:namespace-alias stylesheet-prefix="wwbehaviors" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-documentid" match="wwfiles:File" use="@documentID" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Splits -->
   <!--        -->
   <xsl:for-each select="$GlobalFiles[1]">
    <xsl:variable name="VarDocumentBehaviorsFiles" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

    <xsl:variable name="VarProgressProjectBehaviorsStart" select="wwprogress:Start(count($VarDocumentBehaviorsFiles))" />

    <xsl:for-each select="$VarDocumentBehaviorsFiles">
     <xsl:variable name="VarDocumentBehaviorsFile" select="." />

     <xsl:variable name="VarProgressProjectDocumentStart" select="wwprogress:Start(1)" />

     <xsl:for-each select="$GlobalFiles[1]">
      <xsl:variable name="VarDocumentSplitsFile" select="key('wwfiles-files-by-documentid', $VarDocumentBehaviorsFile/@documentID)[@type = $ParameterDocumentSplitsType]" />

      <!-- Up-to-date? -->
      <!--             -->
      <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($VarDocumentBehaviorsFile/@path), concat(translate($ParameterType, ':', '_'),'.xml'))" />
      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, '', $VarDocumentBehaviorsFile/@groupID, $VarDocumentBehaviorsFile/@documentID, $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <xsl:variable name="VarResultAsXML">
        <xsl:call-template name="Splits">
         <xsl:with-param name="ParamDocumentBehaviorsFile" select="$VarDocumentBehaviorsFile" />
         <xsl:with-param name="ParamDocumentSplitsFile" select="$VarDocumentSplitsFile" />
        </xsl:call-template>
       </xsl:variable>
       <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
       <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, 'utf-8', 'xml', '1.0', 'yes')" />
      </xsl:if>

      <!-- Record file -->
      <!--             -->
      <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="" groupID="{$VarDocumentBehaviorsFile/@groupID}" documentID="{$VarDocumentBehaviorsFile/@documentID}" actionchecksum="{$GlobalActionChecksum}">
       <wwfiles:Depends path="{$VarDocumentBehaviorsFile/@path}" checksum="{$VarDocumentBehaviorsFile/@checksum}" groupID="{$VarDocumentBehaviorsFile/@groupID}" documentID="{$VarDocumentBehaviorsFile/@documentID}" />
       <wwfiles:Depends path="{$VarDocumentSplitsFile/@path}" checksum="{$VarDocumentSplitsFile/@checksum}" groupID="{$VarDocumentSplitsFile/@groupID}" documentID="{$VarDocumentSplitsFile/@documentID}" />
      </wwfiles:File>

     </xsl:for-each>

     <xsl:variable name="VarProgressProjectDocumentEnd" select="wwprogress:End()" />
    </xsl:for-each>

    <xsl:variable name="VarProgressProjectBehaviorsEnd" select="wwprogress:End()" />
   </xsl:for-each>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Splits">
  <xsl:param name="ParamDocumentBehaviorsFile" />
  <xsl:param name="ParamDocumentSplitsFile" />

  <!-- Load document behaviors -->
  <!--                         -->
  <xsl:variable name="VarDocumentBehaviors" select="wwexsldoc:LoadXMLWithoutResolver($ParamDocumentBehaviorsFile/@path)" />

  <!-- Load document splits -->
  <!--                      -->
  <xsl:variable name="VarDocumentSplits" select="wwexsldoc:LoadXMLWithoutResolver($ParamDocumentSplitsFile/@path)" />

  <!-- Behaviors -->
  <!--           -->
  <wwbehaviors:Behaviors version="1.0">

   <xsl:for-each select="$VarDocumentSplits/wwsplits:Splits/wwsplits:Split">
    <xsl:variable name="VarSplit" select="." />

    <!-- Emit split behaviors -->
    <!--                      -->
    <wwbehaviors:Split id="{$VarSplit/@id}" documentposition="{$VarSplit/@documentposition}">
     <xsl:choose>
      <xsl:when test="position() = last()">
       <!-- Select nodes -->
       <!--              -->
       <xsl:variable name="VarSplitDocumentBehaviors" select="$VarDocumentBehaviors/wwbehaviors:Behaviors/wwbehaviors:*[@documentposition &gt;= $VarSplit/@documentposition]" />

       <!-- Handle window types -->
       <!--                     -->
       <xsl:variable name="VarWindowTypesCount" select="count($VarSplitDocumentBehaviors[string-length(@window-type) &gt; 0])" />
       <xsl:if test="$VarWindowTypesCount &gt; 0">
        <xsl:attribute name="window-type">
         <xsl:variable name="VarElement" select="$VarSplitDocumentBehaviors[string-length(@window-type) &gt; 0][$VarWindowTypesCount]" />
         <xsl:value-of select="$VarElement/@window-type" />
        </xsl:attribute>
       </xsl:if>

       <!-- Process children -->
       <!--                  -->
       <xsl:call-template name="SplitDocumentBehaviors">
        <xsl:with-param name="ParamSplitDocumentBehaviors" select="$VarSplitDocumentBehaviors" />
       </xsl:call-template>
      </xsl:when>

      <xsl:otherwise>
       <!-- Select nodes -->
       <!--              -->
       <xsl:variable name="VarEndDocumentPosition" select="$VarSplit/following-sibling::wwsplits:Split[1]/@documentposition - 1" />
       <xsl:variable name="VarSplitDocumentBehaviors" select="$VarDocumentBehaviors/wwbehaviors:Behaviors/wwbehaviors:*[(@documentposition &gt;= $VarSplit/@documentposition) and (@documentposition &lt;= $VarEndDocumentPosition)]" />

       <!-- Handle window types -->
       <!--                     -->
       <xsl:variable name="VarWindowTypesCount" select="count($VarSplitDocumentBehaviors[string-length(@window-type) &gt; 0])" />
       <xsl:if test="$VarWindowTypesCount &gt; 0">
        <xsl:attribute name="window-type">
         <xsl:variable name="VarElement" select="$VarSplitDocumentBehaviors[string-length(@window-type) &gt; 0][$VarWindowTypesCount]" />
         <xsl:value-of select="$VarElement/@window-type" />
        </xsl:attribute>
       </xsl:if>

       <!-- Process children -->
       <!--                  -->
       <xsl:call-template name="SplitDocumentBehaviors">
        <xsl:with-param name="ParamSplitDocumentBehaviors" select="$VarSplitDocumentBehaviors" />
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </wwbehaviors:Split>
   </xsl:for-each>

  </wwbehaviors:Behaviors>
 </xsl:template>


 <xsl:template name="SplitDocumentBehaviors">
  <xsl:param name="ParamSplitDocumentBehaviors" />

  <xsl:for-each select="$ParamSplitDocumentBehaviors">
   <xsl:variable name="VarSplitDocumentBehavior" select="." />

   <xsl:choose>
    <!-- Handle end of split dropdown close out -->
    <!--                                        -->
    <xsl:when test="position() = last()">
     <xsl:element name="{local-name()}" namespace="{namespace-uri()}">
      <xsl:copy-of select="@*[local-name() != 'dropdown']" />

      <xsl:attribute name="dropdown">
       <xsl:choose>
        <!-- Preserve break -->
        <!--                -->
        <xsl:when test="@dropdown = 'break'">
         <xsl:value-of select="@dropdown" />
        </xsl:when>

        <!-- Force dropdown end at the end of the page -->
        <!--                                           -->
        <xsl:otherwise>
         <xsl:value-of select="'end'" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:attribute>

      <!-- Copy children -->
      <!--               -->
      <xsl:copy-of select="$VarSplitDocumentBehavior/*" />
     </xsl:element>
    </xsl:when>

    <!-- Copy as is -->
    <!--            -->
    <xsl:otherwise>
     <xsl:copy-of select="$VarSplitDocumentBehavior" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
